// keyboard.h


typedef struct 
{ 
	UInt8 keyWidth, keyHeight, scancode;
  	char *keyLabel;
} KeyboardLayout;

Boolean KybdKeyIsPressed( int which );
Boolean KybdGetKeyUpdates( UInt8 *key, UInt8 *state );
void KeyboardPreferences( short item );
void KeyboardSetup( void );
void InitKeyboard( void );
void RenderKey( KeyboardLayout *key, Rect *rect );
void PlotKeyIcon( short which );
void UnplotKeyIcon( short which );
Boolean KeyCodeInUse( short which );
short DragGrayRect( Point mouseAt, short changeKey );
short FindHitKey( Point where );
pascal Boolean KeyboardSetupFilterProc( DialogPtr theDialog,
										EventRecord *theEvent,
										short *itemHit );

#define kKeys 9

extern UInt8 keyCode[kKeys];

enum
{
	kKey1PLeft = 0,
	kKey1PRight,
	kKey1PDrop,
	kKey1PRotate,
	kKey2PLeft,
	kKey2PRight,
	kKey2PDrop,
	kKey2PRotate,
	kKeyPause
};